/*
 * Decompiled with CFR 0.152.
 */
package uws.service.controller;

import java.io.Serializable;
import java.util.Map;
import uws.UWSException;
import uws.job.AbstractJob;

public class ExecutionDurationController
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected long defaultDuration = 0L;
    protected long maxDuration = 0L;
    protected boolean allowModification = true;

    public final long getDefaultExecutionDuration() {
        return this.defaultDuration;
    }

    public final boolean setDefaultExecutionDuration(long defaultExecutionDuration) {
        long l = defaultExecutionDuration = defaultExecutionDuration <= 0L ? 0L : defaultExecutionDuration;
        if (defaultExecutionDuration != 0L && this.maxDuration != 0L && defaultExecutionDuration > this.maxDuration) {
            return false;
        }
        this.defaultDuration = defaultExecutionDuration;
        return true;
    }

    public final long getMaxExecutionDuration() {
        return this.maxDuration;
    }

    public final void setMaxExecutionDuration(long maxExecutionDuration) {
        long l = this.maxDuration = maxExecutionDuration <= 0L ? 0L : maxExecutionDuration;
        if (this.defaultDuration != 0L && this.maxDuration != 0L && this.defaultDuration > this.maxDuration) {
            this.defaultDuration = this.maxDuration;
        }
    }

    public final boolean allowModification() {
        return this.allowModification;
    }

    public final void allowModification(boolean allowModification) {
        this.allowModification = allowModification;
    }

    public void init(Map<String, String> params) throws UWSException {
        this.control(null, params);
        if (!params.containsKey("executionduration")) {
            params.put("executionduration", Long.toString(this.defaultDuration));
        }
    }

    public void control(AbstractJob job, Map<String, String> params) throws UWSException {
        if (params.containsKey("executionduration")) {
            String execDuration = params.get("executionduration");
            try {
                this.control(job, Long.parseLong(execDuration));
            }
            catch (NumberFormatException nfe) {
                throw new UWSException(400, "[Set executionDuration] The given execution duration (" + execDuration + ") is not valid: it must be a long (numeric) value !");
            }
            catch (UWSException ue) {
                throw new UWSException(ue.getHttpErrorCode(), "[Set executionDuration] " + ue.getMessage(), ue.getUWSErrorType());
            }
        }
    }

    public void control(AbstractJob jobToControl, long durationToCheck) throws UWSException {
        if (jobToControl != null && !jobToControl.getPhaseManager().isJobUpdatable()) {
            throw new UWSException(400, "Impossible to update any field (executionDuration included) of the job " + jobToControl.getJobId() + " because its phase is " + (Object)((Object)jobToControl.getPhase()) + " !");
        }
        if (!this.allowModification) {
            throw new UWSException(400, "The UWS forbids the modification of the execution duration !");
        }
        if (this.maxDuration > 0L && durationToCheck > this.maxDuration) {
            throw new UWSException(400, "The UWS limits the execution duration to " + this.maxDuration + " seconds !");
        }
    }

    public void setDefaultExecutionDuration(AbstractJob job) throws UWSException {
        this.setExecutionDuration(job, this.defaultDuration);
    }

    public void setExecutionDuration(AbstractJob job, long duration) throws UWSException {
        this.control(job, duration);
        job.setExecutionDuration(duration);
    }
}

