/*
 * Decompiled with CFR 0.152.
 */
package uws.service.controller;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import uws.UWSException;
import uws.job.AbstractJob;

public class DestructionTimeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int NO_INTERVAL = 0;
    protected Date defaultTime = null;
    protected DateField defaultIntervalField = null;
    protected int defaultInterval = 0;
    protected Date maxTime = null;
    protected DateField maxIntervalField = null;
    protected int maxInterval = 0;
    protected boolean allowModification = true;

    public final Date getDefaultDestructionTime() {
        if (this.defaultInterval > 0) {
            Calendar date = Calendar.getInstance();
            try {
                date.add(this.defaultIntervalField.getFieldIndex(), this.defaultInterval);
                return date.getTime();
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return null;
            }
        }
        return this.defaultTime;
    }

    public final void setDefaultDestructionTime(Date defaultDestructionTime) {
        this.defaultTime = defaultDestructionTime;
        this.defaultInterval = 0;
        this.defaultIntervalField = null;
    }

    public final int getDefaultDestructionInterval() {
        return this.defaultInterval;
    }

    public final DateField getDefaultIntervalField() {
        return this.defaultIntervalField;
    }

    public final void setDefaultDestructionInterval(int defaultDestructionInterval) {
        this.setDefaultDestructionInterval(defaultDestructionInterval, DateField.MINUTE);
    }

    public final void setDefaultDestructionInterval(int defaultDestructionInterval, DateField timeField) {
        if (defaultDestructionInterval <= 0 || timeField == null) {
            this.defaultIntervalField = null;
            this.defaultInterval = 0;
        } else {
            this.defaultIntervalField = timeField;
            this.defaultInterval = defaultDestructionInterval;
        }
        this.defaultTime = null;
    }

    public final Date getMaxDestructionTime() {
        if (this.maxInterval > 0) {
            Calendar date = Calendar.getInstance();
            try {
                date.add(this.maxIntervalField.getFieldIndex(), this.maxInterval);
                return date.getTime();
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return null;
            }
        }
        return this.maxTime;
    }

    public final void setMaxDestructionTime(Date maxDestructionTime) {
        this.maxTime = maxDestructionTime;
        this.maxInterval = 0;
        this.maxIntervalField = null;
    }

    public final int getMaxDestructionInterval() {
        return this.maxInterval;
    }

    public final DateField getMaxIntervalField() {
        return this.maxIntervalField;
    }

    public final void setMaxDestructionInterval(int maxDestructionInterval) {
        this.setMaxDestructionInterval(maxDestructionInterval, DateField.MINUTE);
    }

    public final void setMaxDestructionInterval(int maxDestructionInterval, DateField timeField) {
        this.maxInterval = maxDestructionInterval;
        this.maxIntervalField = timeField;
        this.maxTime = null;
    }

    public final boolean allowModification() {
        return this.allowModification;
    }

    public final void allowModification(boolean allowModification) {
        this.allowModification = allowModification;
    }

    public void init(Map<String, String> params) throws UWSException {
        this.control(null, params);
        if (!params.containsKey("destruction")) {
            Date date = this.getDefaultDestructionTime();
            params.put("destruction", date == null ? null : DestructionTimeController.getDateFormat(null).format(date));
        }
    }

    public void control(AbstractJob job, Map<String, String> params) throws UWSException {
        if (params.containsKey("destruction")) {
            String destruction = params.get("destruction");
            try {
                Date destDate = DestructionTimeController.getDateFormat(job).parse(destruction);
                this.control(job, destDate);
            }
            catch (ParseException e) {
                throw new UWSException("[Set destruction] The destruction time format is incorrect.");
            }
            catch (UWSException ue) {
                throw new UWSException(ue.getHttpErrorCode(), "[Set destruction] " + ue.getMessage(), ue.getUWSErrorType());
            }
        }
    }

    public void control(AbstractJob jobToControl, Date dateToCheck) throws UWSException {
        if (jobToControl != null && !jobToControl.getPhaseManager().isJobUpdatable()) {
            throw new UWSException(400, "Impossible to update any field (destruction included) of the job " + jobToControl.getJobId() + " because its phase is " + (Object)((Object)jobToControl.getPhase()) + " !");
        }
        if (!this.allowModification) {
            throw new UWSException(400, "The UWS forbids the modification of the destruction time !");
        }
        Date maxDate = this.getMaxDestructionTime();
        if (maxDate != null && dateToCheck.after(maxDate)) {
            throw new UWSException(400, "The UWS limits " + (this.defaultInterval > 0 ? "the destruction interval (since now) to " + this.maxInterval + " " + this.maxIntervalField.name().toLowerCase() + "s" : "the destruction time to " + maxDate) + " !");
        }
    }

    public void setDefaultDestructionTime(AbstractJob job) throws UWSException {
        this.setDestructionTime(job, this.getDefaultDestructionTime());
    }

    public void setDestructionTime(AbstractJob job, Date date) throws UWSException {
        this.control(job, date);
        job.setDestructionTime(date);
    }

    public static final DateFormat getDateFormat(AbstractJob job) {
        if (job == null || job.getDateFormat() == null) {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        }
        return job.getDateFormat();
    }

    public static enum DateField {
        SECOND(13),
        MINUTE(12),
        HOUR(10),
        DAY(5),
        MONTH(2),
        YEAR(1);

        private final int index;

        private DateField(int fieldIndex) {
            this.index = fieldIndex;
        }

        public final int getFieldIndex() {
            return this.index;
        }
    }
}

