/*
 * Decompiled with CFR 0.152.
 */
package uws.service.actions;

import java.io.IOException;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uws.UWSException;
import uws.job.AbstractJob;
import uws.job.JobList;
import uws.service.AbstractUWS;
import uws.service.UWSUrl;

public abstract class UWSAction<JL extends JobList<J>, J extends AbstractJob>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String LIST_JOBS = "List Jobs";
    public static final String ADD_JOB = "Add Job";
    public static final String DESTROY_JOB = "Destroy Job";
    public static final String JOB_SUMMARY = "Get Job";
    public static final String GET_JOB_PARAM = "Get Job Parameter";
    public static final String SET_JOB_PARAM = "Set Job Parameter";
    public static final String HOME_PAGE = "Show UWS Home Page";
    protected final AbstractUWS<JL, J> uws;

    protected UWSAction(AbstractUWS<JL, J> u) {
        this.uws = u;
    }

    public final AbstractUWS<JL, J> getUWS() {
        return this.uws;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public String getDescription() {
        return "";
    }

    protected final JL getJobsList(UWSUrl urlInterpreter) throws UWSException {
        String jlName = urlInterpreter.getJobListName();
        JL jobsList = null;
        if (jlName != null) {
            jobsList = this.uws.getJobList(jlName);
            if (jobsList == null) {
                throw new UWSException(400, "[" + this.getName() + "] The job list \"" + jlName + "\" does not exist ! (note: the jobs list names are case sensitive)");
            }
        } else {
            throw new UWSException(400, "[" + this.getName() + "] The jobs list name is missing !");
        }
        return jobsList;
    }

    protected final J getJob(UWSUrl urlInterpreter) throws UWSException {
        String jobId = urlInterpreter.getJobId();
        J job = null;
        if (jobId != null) {
            JL jobsList = this.getJobsList(urlInterpreter);
            job = ((JobList)jobsList).getJob(jobId);
            if (job == null) {
                throw new UWSException(400, "[" + this.getName() + "] The job \"" + jobId + "\" does not exist in the jobs list \"" + ((JobList)jobsList).getName() + "\" ! (note: the job IDs are case sensitive)");
            }
        } else {
            throw new UWSException(400, "[" + this.getName() + "] The job ID is missing !");
        }
        return job;
    }

    protected final J getJob(UWSUrl urlInterpreter, JL jobsList) throws UWSException {
        String jobId = urlInterpreter.getJobId();
        J job = null;
        if (jobId != null) {
            if (jobsList == null) {
                throw new UWSException(400, "[" + this.getName() + "] The jobs list name is missing !");
            }
            job = ((JobList)jobsList).getJob(jobId);
            if (job == null) {
                throw new UWSException(400, "[" + this.getName() + "] The job \"" + jobId + "\" does not exist in the jobs list \"" + ((JobList)jobsList).getName() + "\" ! (note: the job IDs are case sensitive)");
            }
        } else {
            throw new UWSException(400, "[" + this.getName() + "] The job ID is missing !");
        }
        return job;
    }

    public abstract boolean match(UWSUrl var1, String var2, HttpServletRequest var3) throws UWSException;

    public abstract boolean apply(UWSUrl var1, String var2, HttpServletRequest var3, HttpServletResponse var4) throws UWSException, IOException;

    public final boolean equals(Object obj) {
        if (obj instanceof UWSAction) {
            return this.getName().equals(((UWSAction)obj).getName());
        }
        return super.equals(obj);
    }

    public String toString() {
        return this.getName();
    }
}

