/*
 * Decompiled with CFR 0.152.
 */
package uws.service.actions;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uws.UWSException;
import uws.UWSToolBox;
import uws.job.AbstractJob;
import uws.job.JobList;
import uws.service.AbstractUWS;
import uws.service.UWSUrl;
import uws.service.actions.UWSAction;

public class SetJobParam<JL extends JobList<J>, J extends AbstractJob>
extends UWSAction<JL, J> {
    private static final long serialVersionUID = 1L;

    public SetJobParam(AbstractUWS<JL, J> u) {
        super(u);
    }

    @Override
    public String getName() {
        return "Set Job Parameter";
    }

    @Override
    public String getDescription() {
        return "Sets the value of a job attribute/parameter of the specified job. (URL: {baseUWS_URL}/{jobListName}/{job-id}/{job-attribute}, Method: HTTP-POST or HTTP-PUT, Parameter: {JOB-ATTRIBUTE}={attribute-value})";
    }

    @Override
    public boolean match(UWSUrl urlInterpreter, String userId, HttpServletRequest request) throws UWSException {
        return urlInterpreter.hasJobList() && urlInterpreter.hasJob() && (request.getMethod().equalsIgnoreCase("post") && (!urlInterpreter.hasAttribute() || urlInterpreter.getAttributes().length == 1) && request.getParameterMap().size() > 0 || request.getMethod().equalsIgnoreCase("put") && urlInterpreter.getAttributes().length >= 2 && urlInterpreter.getAttributes()[0].equalsIgnoreCase("parameters") && request.getParameter(urlInterpreter.getAttributes()[1]) != null);
    }

    @Override
    public boolean apply(UWSUrl urlInterpreter, String userId, HttpServletRequest request, HttpServletResponse response) throws UWSException, IOException {
        Object job = this.getJob(urlInterpreter);
        Map<String, String> params = UWSToolBox.getParamsMap(request);
        this.uws.getExecutionDurationController().control((AbstractJob)job, params);
        this.uws.getDestructionTimeController().control((AbstractJob)job, params);
        boolean updated = ((AbstractJob)job).addOrUpdateParameters(params);
        this.uws.redirect(urlInterpreter.jobSummary(urlInterpreter.getJobListName(), ((AbstractJob)job).getJobId()).getRequestURL(), request, response);
        return updated;
    }
}

