/*
 * Decompiled with CFR 0.152.
 */
package uws.service.actions;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uws.UWSException;
import uws.job.AbstractJob;
import uws.job.JobList;
import uws.job.SerializableUWSObject;
import uws.job.serializer.UWSSerializer;
import uws.service.AbstractUWS;
import uws.service.UWSUrl;
import uws.service.actions.UWSAction;

public class ListJobs<JL extends JobList<J>, J extends AbstractJob>
extends UWSAction<JL, J> {
    private static final long serialVersionUID = 1L;

    public ListJobs(AbstractUWS<JL, J> u) {
        super(u);
    }

    @Override
    public String getName() {
        return "List Jobs";
    }

    @Override
    public String getDescription() {
        return "Gives a list of all jobs contained into the specified jobs list. (URL: {baseUWS_URL}/{jobListName}, Method: HTTP-GET, No parameters)";
    }

    @Override
    public boolean match(UWSUrl urlInterpreter, String userId, HttpServletRequest request) throws UWSException {
        return urlInterpreter.hasJobList() && !urlInterpreter.hasJob() && request.getMethod().equalsIgnoreCase("get");
    }

    @Override
    public boolean apply(UWSUrl urlInterpreter, String userId, HttpServletRequest request, HttpServletResponse response) throws UWSException, IOException {
        Object jobsList = this.getJobsList(urlInterpreter);
        UWSSerializer serializer = this.uws.getSerializer(request.getHeader("Accept"));
        response.setContentType(serializer.getMimeType());
        ((SerializableUWSObject)jobsList).serialize((OutputStream)response.getOutputStream(), serializer, userId);
        return true;
    }
}

