/*
 * Decompiled with CFR 0.152.
 */
package uws.service.actions;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uws.UWSException;
import uws.job.AbstractJob;
import uws.job.JobList;
import uws.service.AbstractUWS;
import uws.service.UWSUrl;
import uws.service.actions.UWSAction;

public class DestroyJob<JL extends JobList<J>, J extends AbstractJob>
extends UWSAction<JL, J> {
    private static final long serialVersionUID = 1L;

    public DestroyJob(AbstractUWS<JL, J> u) {
        super(u);
    }

    @Override
    public String getName() {
        return "Destroy Job";
    }

    @Override
    public String getDescription() {
        return "Lets stopping the specified job, removing it from its jobs list and destroying all its associated resources. (URL: {baseUWS_URL}/{jobListName}/{job-id}, Method: HTTP-DELETE, No parameter) or (URL: {baseUWS_URL}/{jobListName}/{job-id}, Method: HTTP-POST, Parameter: ACTION=DELETE)";
    }

    @Override
    public boolean match(UWSUrl urlInterpreter, String userId, HttpServletRequest request) throws UWSException {
        return urlInterpreter.hasJobList() && urlInterpreter.hasJob() && (request.getMethod().equalsIgnoreCase("delete") || request.getMethod().equalsIgnoreCase("post") && request.getParameter("ACTION") != null && request.getParameter("ACTION").equalsIgnoreCase("DELETE"));
    }

    @Override
    public boolean apply(UWSUrl urlInterpreter, String userId, HttpServletRequest request, HttpServletResponse response) throws UWSException, IOException {
        Object jobsList = this.getJobsList(urlInterpreter);
        Object job = this.getJob(urlInterpreter, jobsList);
        boolean destroyed = ((JobList)jobsList).destroyJob(((AbstractJob)job).getJobId());
        this.uws.redirect(urlInterpreter.listJobs(((JobList)jobsList).getName()).getRequestURL(), request, response);
        return destroyed;
    }
}

