/*
 * Decompiled with CFR 0.152.
 */
package uws.service;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import uws.UWSException;
import uws.UWSToolBox;

public class UWSUrl
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String requestURL = null;
    protected String urlHeader = null;
    protected String requestURI = null;
    protected final String baseURI;
    protected String uwsURI = null;
    protected String jobListName = null;
    protected String jobId = null;
    protected String[] attributes = new String[0];

    public UWSUrl(UWSUrl toCopy) {
        this.requestURL = toCopy.requestURL;
        this.urlHeader = toCopy.urlHeader;
        this.requestURI = toCopy.requestURI;
        this.baseURI = toCopy.baseURI;
        this.uwsURI = toCopy.uwsURI;
        this.jobListName = toCopy.jobListName;
        this.jobId = toCopy.jobId;
        this.attributes = new String[toCopy.attributes.length];
        System.arraycopy(toCopy.attributes, 0, this.attributes, 0, this.attributes.length);
    }

    public UWSUrl(String baseURI) throws UWSException {
        if (baseURI == null) {
            throw new UWSException(500, "[Create a UWS URL interpreter] The given base UWS URI is NULL !");
        }
        this.baseURI = UWSUrl.normalizeURI(baseURI);
        if (baseURI.length() == 0) {
            throw new UWSException(500, "[Create a UWS URL interpreter] The given base UWS URI is empty !");
        }
    }

    public UWSUrl(HttpServletRequest request) throws UWSException {
        String uri = this.extractBaseURI(request);
        if (uri == null) {
            throw new UWSException(500, "[Create a UWS URL interpreter] The extracted base UWS URI is NULL !");
        }
        this.baseURI = UWSUrl.normalizeURI(uri);
        if (this.baseURI.length() == 0) {
            throw new UWSException(500, "[Create a UWS URL interpreter] The extracted base UWS URI is empty !");
        }
    }

    protected String extractBaseURI(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        return request.getServletPath();
    }

    protected static final String normalizeURI(String uri) {
        if (!(uri = uri.trim()).startsWith("/")) {
            uri = "/" + uri;
        }
        while (uri.endsWith("/") && uri.length() >= 1) {
            uri = uri.substring(0, uri.length() - 1).trim();
        }
        return uri.trim();
    }

    public void load(HttpServletRequest request) {
        if (request == null) {
            this.urlHeader = null;
            this.requestURL = null;
            this.requestURI = null;
            this.uwsURI = null;
        } else if (this.extractBaseURI(request).equalsIgnoreCase(this.baseURI)) {
            this.requestURL = new String(request.getRequestURL());
            this.urlHeader = String.valueOf(request.getScheme()) + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
            this.requestURI = request.getRequestURI().substring(request.getRequestURI().indexOf(this.baseURI));
            this.uwsURI = request.getPathInfo();
        } else {
            URL url = null;
            try {
                url = new URL(request.getRequestURL().toString());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            this.load(url);
            return;
        }
        this.loadUwsURI();
    }

    public void load(URL requestUrl) {
        if (requestUrl == null) {
            this.urlHeader = null;
            this.requestURL = null;
            this.requestURI = null;
            this.uwsURI = null;
        } else {
            int indBaseURI;
            this.requestURL = requestUrl.toString();
            if (this.requestURL.indexOf("?") > 0) {
                this.requestURL = this.requestURL.substring(0, this.requestURL.indexOf("?"));
            }
            if ((indBaseURI = this.requestURL.indexOf(this.baseURI)) >= 0) {
                this.urlHeader = this.requestURL.substring(0, indBaseURI);
                this.requestURI = this.requestURL.substring(indBaseURI);
                this.uwsURI = this.requestURI.substring(this.baseURI.length());
            } else {
                this.urlHeader = null;
                this.requestURI = null;
                this.uwsURI = null;
            }
        }
        this.loadUwsURI();
    }

    protected void loadUwsURI() {
        this.jobListName = null;
        this.jobId = null;
        this.attributes = new String[0];
        if (this.uwsURI != null) {
            this.uwsURI = UWSUrl.normalizeURI(this.uwsURI);
            String[] uriParts = this.uwsURI.split("/");
            if (uriParts.length >= 2) {
                this.jobListName = uriParts[1].trim();
                if (this.jobListName.length() == 0) {
                    this.jobListName = null;
                }
            }
            if (uriParts.length >= 3) {
                this.jobId = uriParts[2].trim();
                if (this.jobId.length() == 0) {
                    this.jobId = null;
                }
            }
            if (uriParts.length >= 4) {
                this.attributes = new String[uriParts.length - 3];
                int i = 3;
                while (i < uriParts.length) {
                    this.attributes[i - 3] = uriParts[i].trim();
                    ++i;
                }
            }
        }
    }

    public final String getBaseURI() {
        return this.baseURI;
    }

    public final String getUWSName() {
        return this.baseURI.substring(this.baseURI.lastIndexOf("/") + 1);
    }

    public final String getRequestURL() {
        return this.requestURL;
    }

    public final String getUrlHeader() {
        return this.urlHeader;
    }

    public final String getRequestURI() {
        return this.requestURI;
    }

    public final String getUwsURI() {
        return this.uwsURI;
    }

    public final boolean hasJobList() {
        return this.jobListName != null;
    }

    public final String getJobListName() {
        return this.jobListName;
    }

    public final boolean hasJob() {
        return this.jobId != null;
    }

    public final String getJobId() {
        return this.jobId;
    }

    public final boolean hasAttribute() {
        return this.attributes != null && this.attributes.length > 0;
    }

    public final boolean hasAttribute(String attributeName) {
        String[] stringArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String att = stringArray[n2];
            if (att.equalsIgnoreCase(attributeName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public final String[] getAttributes() {
        return this.attributes;
    }

    protected void updateUwsURI() {
        this.uwsURI = null;
        if (this.hasJobList()) {
            this.uwsURI = "/" + this.jobListName;
            if (this.hasJob()) {
                this.uwsURI = String.valueOf(this.uwsURI) + "/" + this.jobId;
                if (this.hasAttribute()) {
                    String[] stringArray = this.attributes;
                    int n = this.attributes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String att = stringArray[n2];
                        this.uwsURI = String.valueOf(this.uwsURI) + "/" + att;
                        ++n2;
                    }
                }
            }
        }
        this.updateRequestURL();
    }

    protected void updateRequestURL() {
        this.requestURI = String.valueOf(this.baseURI) + (this.uwsURI != null ? this.uwsURI : "");
        this.requestURL = this.urlHeader == null ? null : String.valueOf(this.urlHeader) + this.requestURI;
    }

    public final void setUwsURI(String uwsURI) {
        this.uwsURI = uwsURI == null || uwsURI.trim().length() == 0 ? null : uwsURI.trim();
        this.loadUwsURI();
        this.updateRequestURL();
    }

    public final void setJobListName(String jobListName) {
        this.jobListName = jobListName;
        this.updateUwsURI();
    }

    public final void setJobId(String jobId) {
        this.jobId = jobId;
        this.updateUwsURI();
    }

    public final void setAttributes(String[] newAttributes) {
        if (newAttributes == null) {
            this.attributes = new String[0];
        }
        this.attributes = new String[newAttributes.length];
        System.arraycopy(newAttributes, 0, this.attributes, 0, this.attributes.length);
        this.updateUwsURI();
    }

    public final UWSUrl homePage() {
        UWSUrl url = new UWSUrl(this);
        url.setUwsURI(null);
        return url;
    }

    public final UWSUrl listJobs(String jobListName) {
        UWSUrl url = this.homePage();
        url.setJobListName(jobListName);
        return url;
    }

    public final UWSUrl jobSummary(String jobListName, String jobId) {
        UWSUrl url = this.listJobs(jobListName);
        url.setJobId(jobId);
        return url;
    }

    public final UWSUrl jobName(String jobListName, String jobId) {
        UWSUrl url = this.jobSummary(jobListName, jobId);
        url.setAttributes(new String[]{"runid"});
        return url;
    }

    public final UWSUrl jobPhase(String jobListName, String jobId) {
        UWSUrl url = this.jobSummary(jobListName, jobId);
        url.setAttributes(new String[]{"phase"});
        return url;
    }

    public final UWSUrl jobExecDuration(String jobListName, String jobId) {
        UWSUrl url = this.jobSummary(jobListName, jobId);
        url.setAttributes(new String[]{"executionduration"});
        return url;
    }

    public final UWSUrl jobDestruction(String jobListName, String jobId) {
        UWSUrl url = this.jobSummary(jobListName, jobId);
        url.setAttributes(new String[]{"destruction"});
        return url;
    }

    public final UWSUrl jobError(String jobListName, String jobId) {
        UWSUrl url = this.jobSummary(jobListName, jobId);
        url.setAttributes(new String[]{"error"});
        return url;
    }

    public final UWSUrl jobQuote(String jobListName, String jobId) {
        UWSUrl url = this.jobSummary(jobListName, jobId);
        url.setAttributes(new String[]{"quote"});
        return url;
    }

    public final UWSUrl jobResults(String jobListName, String jobId) {
        UWSUrl url = this.jobSummary(jobListName, jobId);
        url.setAttributes(new String[]{"results"});
        return url;
    }

    public final UWSUrl jobResult(String jobListName, String jobId, String resultId) {
        UWSUrl url = this.jobSummary(jobListName, jobId);
        url.setAttributes(new String[]{"results", resultId});
        return url;
    }

    public final UWSUrl jobParameters(String jobListName, String jobId) {
        UWSUrl url = this.jobSummary(jobListName, jobId);
        url.setAttributes(new String[]{"parameters"});
        return url;
    }

    public final UWSUrl jobParameter(String jobListName, String jobId, String paramName) {
        UWSUrl url = this.jobSummary(jobListName, jobId);
        url.setAttributes(new String[]{"parameters", paramName});
        return url;
    }

    public final UWSUrl jobOwner(String jobListName, String jobId) {
        UWSUrl url = this.jobSummary(jobListName, jobId);
        url.setAttributes(new String[]{"owner"});
        return url;
    }

    public final String createJob(String jobListName, Map<String, String> parameters) {
        return this.listJobs(jobListName) + "?" + UWSToolBox.getQueryPart(parameters);
    }

    public final String deleteJob(String jobListName, String jobId) {
        return this.jobSummary(jobListName, jobId) + "?" + "ACTION" + "=" + "DELETE";
    }

    public final String startJob(String jobListName, String jobId) {
        return this.jobPhase(jobListName, jobId) + "?" + "phase".toUpperCase() + "=" + "RUN";
    }

    public final String abortJob(String jobListName, String jobId) {
        return this.jobPhase(jobListName, jobId) + "?" + "phase".toUpperCase() + "=" + "ABORT";
    }

    public final String changeJobName(String jobListName, String jobId, String newName) {
        return this.jobName(jobListName, jobId) + "?" + "runid".toUpperCase() + "=" + newName;
    }

    public final String changeDestructionTime(String jobListName, String jobId, String newDestructionTime) {
        return this.jobDestruction(jobListName, jobId) + "?" + "destruction".toUpperCase() + "=" + newDestructionTime;
    }

    public final String changeExecDuration(String jobListName, String jobId, String newExecDuration) {
        return this.jobExecDuration(jobListName, jobId) + "?" + "executionduration".toUpperCase() + "=" + newExecDuration;
    }

    public final String changeJobParam(String jobListName, String jobId, String paramName, String paramValue) {
        return this.jobParameters(jobListName, jobId) + "?" + paramName.toUpperCase() + "=" + paramValue;
    }

    public URL toURL() throws MalformedURLException {
        String url = this.getRequestURL();
        return url != null ? new URL(url) : null;
    }

    public String toURI() {
        return this.getRequestURI();
    }

    public String toString() {
        return this.getRequestURL();
    }
}

