/*
 * Decompiled with CFR 0.152.
 */
package uws.service;

import uws.UWSException;
import uws.job.AbstractJob;
import uws.job.manager.QueuedExecutionManager;
import uws.service.BasicUWS;
import uws.service.UWSUrl;

public class QueuedBasicUWS<J extends AbstractJob>
extends BasicUWS<J> {
    private static final long serialVersionUID = 1L;

    public QueuedBasicUWS(Class<J> cl, int nbMaxRunningJobs) throws UWSException {
        super(cl);
        this.setExecutionManager(new QueuedExecutionManager(nbMaxRunningJobs));
    }

    public QueuedBasicUWS(Class<J> cl, int nbMaxRunningJobs, String baseURI) throws UWSException {
        super(cl, baseURI);
        this.setExecutionManager(new QueuedExecutionManager(nbMaxRunningJobs));
    }

    public QueuedBasicUWS(Class<J> cl, int nbMaxRunningJobs, UWSUrl urlInterpreter) throws UWSException {
        super(cl, urlInterpreter);
        this.setExecutionManager(new QueuedExecutionManager(nbMaxRunningJobs));
    }

    public final int getMaxRunningJobs() {
        if (this.getExecutionManager() instanceof QueuedExecutionManager) {
            return ((QueuedExecutionManager)this.getExecutionManager()).getMaxRunningJobs();
        }
        return -1;
    }

    public final void setMaxRunningJobs(int maxRunningJobs) throws UWSException {
        if (this.getExecutionManager() instanceof QueuedExecutionManager) {
            ((QueuedExecutionManager)this.getExecutionManager()).setMaxRunningJobs(maxRunningJobs);
        }
    }
}

