/*
 * Decompiled with CFR 0.152.
 */
package uws.service;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uws.UWSException;
import uws.job.AbstractJob;
import uws.job.JobList;
import uws.service.AbstractUWS;
import uws.service.UWSUrl;
import uws.service.actions.AddJob;

public class ExtendedUWS
extends AbstractUWS<JobList<AbstractJob>, AbstractJob> {
    private static final long serialVersionUID = 1L;
    protected final Map<JobList<? extends AbstractJob>, Class<? extends AbstractJob>> assocJobListClass = new HashMap<JobList<? extends AbstractJob>, Class<? extends AbstractJob>>();
    protected transient Map<JobList<? extends AbstractJob>, Constructor<? extends AbstractJob>> assocJobListConstructor = new HashMap<JobList<? extends AbstractJob>, Constructor<? extends AbstractJob>>();
    protected JobList<? extends AbstractJob> jlDestination = null;

    public ExtendedUWS() {
        this.replaceUWSAction(new AddJobWithConstructor(this));
    }

    public ExtendedUWS(String baseURI) throws UWSException {
        super(baseURI);
        this.replaceUWSAction(new AddJobWithConstructor(this));
    }

    public ExtendedUWS(UWSUrl urlInterpreter) {
        super(urlInterpreter);
        this.replaceUWSAction(new AddJobWithConstructor(this));
    }

    protected final Constructor<? extends AbstractJob> getConstructor(JobList<? extends AbstractJob> jl) throws UWSException {
        try {
            if (this.assocJobListConstructor == null) {
                this.assocJobListConstructor = new HashMap<JobList<? extends AbstractJob>, Constructor<? extends AbstractJob>>();
                for (Map.Entry<JobList<? extends AbstractJob>, Class<? extends AbstractJob>> entry : this.assocJobListClass.entrySet()) {
                    this.addConstructor(entry.getKey());
                }
            } else {
                this.addConstructor(jl);
            }
            Constructor<? extends AbstractJob> constructor = this.assocJobListConstructor.get(jl);
            if (constructor != null) {
                return constructor;
            }
            throw new UWSException(500, "[Get job constructor] Impossible to get the constructor of the type of job to create for the job list \"" + jl.getName() + "\" !");
        }
        catch (UWSException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    protected final void addConstructor(JobList<? extends AbstractJob> jl) throws UWSException {
        Class<? extends AbstractJob> jobClass = this.assocJobListClass.get(jl);
        if (jobClass == null) {
            throw new UWSException(500, "[Get job constructor] Impossible to get a job constructor from a NULL Class object !");
        }
        if (Modifier.isAbstract(jobClass.getModifiers())) {
            throw new UWSException(500, "[Get job constructor] The class \"" + jobClass.getName() + "\" is abstract. It is impossible to build a BasicUWS object with an abstract class !");
        }
        try {
            this.assocJobListConstructor.put(jl, jobClass.getConstructor(Map.class));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UWSException(500, "[Get job constructor] Impossible to fetch the constructor with only one parameter of type HashMap<String, String> into the class \"" + jobClass.getName() + "\" !");
        }
    }

    public <J extends AbstractJob> boolean addJobList(JobList<J> jl, Class<J> cl) throws UWSException {
        boolean result = this.addJobList(jl);
        if (Modifier.isAbstract(cl.getModifiers())) {
            throw new UWSException(500, "[Add job list] The class \"" + cl.getName() + "\" is abstract. It is impossible to build a BasicUWS object with an abstract class !");
        }
        if (result) {
            this.assocJobListClass.put(jl, cl);
            this.getConstructor(jl);
        }
        return result;
    }

    @Override
    public boolean removeJobList(JobList<AbstractJob> jl) {
        boolean result = super.removeJobList(jl);
        if (result) {
            this.assocJobListClass.remove(jl);
            if (this.assocJobListConstructor != null) {
                this.assocJobListConstructor.remove(jl);
            }
        }
        return result;
    }

    @Override
    public boolean destroyJobList(JobList<AbstractJob> jl) {
        boolean result = super.destroyJobList(jl);
        if (result) {
            this.assocJobListClass.remove(jl);
            if (this.assocJobListConstructor != null) {
                this.assocJobListConstructor.remove(jl);
            }
        }
        return result;
    }

    @Override
    public AbstractJob createJob(Map<String, String> parameters) throws UWSException {
        Constructor<? extends AbstractJob> constructor = null;
        constructor = this.getConstructor(this.jlDestination);
        try {
            try {
                return constructor.newInstance(parameters);
            }
            catch (InvocationTargetException e) {
                throw new UWSException(500, "[Create a job] " + e.getCause() + ": " + e.getMessage());
            }
        }
        catch (Exception e) {
            if (e instanceof UWSException) {
                throw (UWSException)e;
            }
            e.printStackTrace();
            throw new UWSException(500, "[Create a job] Error while using the constructor \"" + constructor.toString() + "\": " + e.getMessage());
        }
    }

    protected class AddJobWithConstructor
    extends AddJob<JobList<AbstractJob>, AbstractJob> {
        private static final long serialVersionUID = 1L;

        public AddJobWithConstructor(AbstractUWS<JobList<AbstractJob>, AbstractJob> u) {
            super(u);
        }

        @Override
        public boolean apply(UWSUrl urlInterpreter, String userId, HttpServletRequest request, HttpServletResponse response) throws UWSException, IOException {
            boolean resultApplied = false;
            ((ExtendedUWS)this.uws).jlDestination = this.getJobsList(urlInterpreter);
            resultApplied = super.apply(urlInterpreter, userId, request, response);
            ((ExtendedUWS)this.uws).jlDestination = null;
            return resultApplied;
        }
    }
}

