/*
 * Decompiled with CFR 0.152.
 */
package uws.service;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Map;
import uws.UWSException;
import uws.job.AbstractJob;
import uws.job.JobList;
import uws.service.AbstractUWS;
import uws.service.UWSUrl;

public class BasicUWS<J extends AbstractJob>
extends AbstractUWS<JobList<J>, J> {
    private static final long serialVersionUID = 1L;
    protected final Class<J> jobClass;
    protected transient Constructor<J> constructor;

    public BasicUWS(Class<J> cl) throws UWSException {
        this.jobClass = cl;
        this.getConstructor();
    }

    public BasicUWS(Class<J> cl, String baseURI) throws UWSException {
        super(baseURI);
        this.jobClass = cl;
        this.getConstructor();
    }

    public BasicUWS(Class<J> cl, UWSUrl urlInterpreter) throws UWSException {
        super(urlInterpreter);
        this.jobClass = cl;
        this.getConstructor();
    }

    protected final Constructor<J> getConstructor() throws UWSException {
        if (this.constructor == null) {
            if (this.jobClass == null) {
                throw new UWSException(500, "[Get job constructor] Impossible to build a BasicUWS with a NULL Class object !");
            }
            if (Modifier.isAbstract(this.jobClass.getModifiers())) {
                throw new UWSException(500, "[Get job constructor] The class \"" + this.jobClass.getName() + "\" is abstract. It is impossible to build a BasicUWS object with an abstract class !");
            }
            try {
                this.constructor = this.jobClass.getConstructor(Map.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new UWSException(500, "[Get job constructor] Impossible to fetch the constructor with only one parameter of type HashMap<String, String> into the class \"" + this.jobClass.getName() + "\" !");
            }
        }
        return this.constructor;
    }

    @Override
    public J createJob(Map<String, String> parameters) throws UWSException {
        try {
            try {
                return (J)((AbstractJob)this.getConstructor().newInstance(parameters));
            }
            catch (InvocationTargetException e) {
                throw new UWSException(500, "[Create a job] " + e.getCause() + ": " + e.getMessage());
            }
        }
        catch (Exception e) {
            if (e instanceof UWSException) {
                throw (UWSException)e;
            }
            e.printStackTrace();
            throw new UWSException(500, "[Create a job] Error while using the constructor \"" + this.constructor.toString() + "\": " + e.getMessage());
        }
    }
}

