/*
 * Decompiled with CFR 0.152.
 */
package uws.service;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import uws.AcceptHeader;
import uws.UWSException;
import uws.job.AbstractJob;
import uws.job.JobList;
import uws.job.SerializableUWSObject;
import uws.job.manager.DefaultDestructionManager;
import uws.job.manager.DefaultExecutionManager;
import uws.job.manager.DestructionManager;
import uws.job.manager.ExecutionManager;
import uws.job.serializer.JSONSerializer;
import uws.job.serializer.UWSSerializer;
import uws.job.serializer.XMLSerializer;
import uws.service.UWSUrl;
import uws.service.UserIdentifier;
import uws.service.actions.AddJob;
import uws.service.actions.DestroyJob;
import uws.service.actions.GetJobParam;
import uws.service.actions.JobSummary;
import uws.service.actions.ListJobs;
import uws.service.actions.SetJobParam;
import uws.service.actions.ShowHomePage;
import uws.service.actions.UWSAction;
import uws.service.controller.DestructionTimeController;
import uws.service.controller.ExecutionDurationController;

public abstract class AbstractUWS<JL extends JobList<J>, J extends AbstractJob>
extends SerializableUWSObject
implements Iterable<JL>,
HttpSessionBindingListener {
    private static final long serialVersionUID = 1L;
    protected String name = null;
    protected String description = null;
    protected final Map<String, JL> mapJobLists = new LinkedHashMap<String, JL>();
    protected UWSUrl urlInterpreter = null;
    protected boolean reInitUrlInterpreter = false;
    private transient String syncStatus = "SYNCHRONIZED";
    protected final Map<String, UWSSerializer> serializers = new HashMap<String, UWSSerializer>();
    protected String defaultSerializer = null;
    protected UWSSerializer choosenSerializer = null;
    protected String homePage = null;
    protected boolean homeRedirection = false;
    private ExecutionDurationController durationController = null;
    private DestructionTimeController destructionController = null;
    protected final Vector<UWSAction<JL, J>> uwsActions;
    protected UWSAction<JL, J> executedAction = null;
    protected UserIdentifier userIdentifier = null;
    private DestructionManager destructionManager;
    private ExecutionManager executionManager;

    public AbstractUWS() {
        this.addSerializer(new XMLSerializer());
        this.addSerializer(new JSONSerializer());
        this.uwsActions = new Vector();
        this.uwsActions.add(new ShowHomePage(this));
        this.uwsActions.add(new ListJobs(this));
        this.uwsActions.add(new AddJob(this));
        this.uwsActions.add(new DestroyJob(this));
        this.uwsActions.add(new JobSummary(this));
        this.uwsActions.add(new GetJobParam(this));
        this.uwsActions.add(new SetJobParam(this));
        this.destructionManager = new DefaultDestructionManager();
        this.executionManager = new DefaultExecutionManager();
        this.durationController = new ExecutionDurationController();
        this.destructionController = new DestructionTimeController();
        this.reInitUrlInterpreter = true;
    }

    protected AbstractUWS(String baseURI) throws UWSException {
        this();
        try {
            this.urlInterpreter = new UWSUrl(baseURI);
            this.name = this.urlInterpreter.getUWSName();
        }
        catch (UWSException ex) {
            throw new UWSException(400, (Throwable)ex, "[Create a UWS] Invalid base UWS URI !");
        }
    }

    protected AbstractUWS(UWSUrl urlInterpreter) {
        this();
        this.setUrlInterpreter(urlInterpreter);
    }

    public final synchronized void sync() {
        if (this.reInitUrlInterpreter) {
            this.urlInterpreter = null;
        }
        if (this.syncStatus == null) {
            this.destructionManager.refresh();
            this.executionManager.sync();
            for (JobList jl : this) {
                jl.sync();
            }
        }
        this.syncStatus = "SYNCHRONIZED";
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final String getBaseURI() {
        return this.urlInterpreter == null ? null : this.urlInterpreter.getBaseURI();
    }

    public final UWSUrl getUrlInterpreter() {
        return this.urlInterpreter;
    }

    public final void setUrlInterpreter(UWSUrl urlInterpreter) {
        this.urlInterpreter = urlInterpreter;
        this.reInitUrlInterpreter = false;
        if (this.name == null && urlInterpreter != null) {
            this.name = urlInterpreter.getUWSName();
        }
    }

    public final ExecutionDurationController getExecutionDurationController() {
        return this.durationController;
    }

    public final void setExecutionDurationController(ExecutionDurationController controller) {
        if (controller != null) {
            this.durationController = controller;
        }
    }

    public final DestructionTimeController getDestructionTimeController() {
        return this.destructionController;
    }

    public final void setDestructionTimeController(DestructionTimeController controller) {
        if (controller != null) {
            this.destructionController = controller;
        }
    }

    public final UserIdentifier getUserIdentifier() {
        return this.userIdentifier;
    }

    public final void setUserIdentifier(UserIdentifier identifier) {
        this.userIdentifier = identifier;
    }

    public final DestructionManager getDestructionManager() {
        return this.destructionManager;
    }

    public final void setDestructionManager(DestructionManager newManager) {
        this.destructionManager = newManager;
        for (JobList jl : this) {
            jl.setDestructionManager(this.destructionManager);
        }
    }

    public final ExecutionManager getExecutionManager() {
        return this.executionManager;
    }

    public final void setExecutionManager(ExecutionManager newManager) throws UWSException {
        if (newManager == null) {
            throw new UWSException(500, "[Set execution manager] Impossible to set a NULL execution manager !");
        }
        this.executionManager = newManager;
        for (JobList jl : this) {
            for (AbstractJob j : jl) {
                j.setExecutionManager(this.executionManager);
            }
        }
    }

    public final String getHomePage() {
        return this.homePage;
    }

    public final boolean isHomePageRedirection() {
        return this.homeRedirection;
    }

    public final void setHomePage(URL homePageUrl, boolean redirect) {
        this.homePage = homePageUrl.toString();
        this.homeRedirection = redirect;
    }

    public final void setHomePage(String homePageURI) {
        this.homePage = homePageURI;
        this.homeRedirection = true;
    }

    public final boolean isDefaultHomePage() {
        return this.homePage == null;
    }

    public final void setDefaultHomePage() {
        this.homePage = null;
        this.homeRedirection = false;
    }

    public final String getDefaultSerializer() {
        return this.defaultSerializer;
    }

    public final void setDefaultSerializer(String mimeType) throws UWSException {
        if (!this.serializers.containsKey(mimeType)) {
            throw new UWSException(500, "[Set default serializer] No UWS Serializer with the MIME type \"" + mimeType + "\" exists in this UWS ! Please add a serializer with this MIME type before setting the default serializer of this UWS !");
        }
        this.defaultSerializer = mimeType;
    }

    public final boolean addSerializer(UWSSerializer serializer) {
        if (serializer != null && !this.serializers.containsKey(serializer.getMimeType())) {
            this.serializers.put(serializer.getMimeType(), serializer);
            if (this.serializers.size() == 1) {
                this.defaultSerializer = serializer.getMimeType();
            }
        }
        return false;
    }

    public final boolean hasSerializerFor(String mimeType) {
        return this.serializers.containsKey(mimeType);
    }

    public final int getNbSerializers() {
        return this.serializers.size();
    }

    public final Iterator<UWSSerializer> getSerializers() {
        return this.serializers.values().iterator();
    }

    public final UWSSerializer getSerializer(String mimeTypes) throws UWSException {
        this.choosenSerializer = null;
        if (mimeTypes != null) {
            AcceptHeader accept = new AcceptHeader(mimeTypes);
            ArrayList<String> lstMimeTypes = accept.getOrderedMimeTypes();
            int i = 0;
            while (this.choosenSerializer == null && i < lstMimeTypes.size()) {
                this.choosenSerializer = this.serializers.get(lstMimeTypes.get(i));
                ++i;
            }
        }
        if (this.choosenSerializer == null) {
            this.choosenSerializer = this.serializers.get(this.defaultSerializer);
            if (this.choosenSerializer == null) {
                throw new UWSException(500, "[Get Serializer] No UWS Serializer available neither for \"" + mimeTypes + "\" (given MIME types) nor \"" + this.defaultSerializer + "\" (default serializer MIME type) !");
            }
        }
        return this.choosenSerializer;
    }

    public final UWSSerializer getChoosenSerializer() {
        return this.choosenSerializer;
    }

    public final UWSSerializer removeSerializer(String mimeType) {
        return this.serializers.remove(mimeType);
    }

    public final String getXsltURL() {
        XMLSerializer serializer = (XMLSerializer)this.serializers.get("application/xml");
        if (serializer != null) {
            return serializer.getXSLTPath();
        }
        return null;
    }

    public final boolean setXsltURL(String xsltPath) {
        XMLSerializer serializer = (XMLSerializer)this.serializers.get("application/xml");
        if (serializer != null) {
            serializer.setXSLTPath(xsltPath);
            return true;
        }
        return false;
    }

    @Override
    public final Iterator<JL> iterator() {
        return this.mapJobLists.values().iterator();
    }

    public final JL getJobList(String name) {
        return (JL)((JobList)this.mapJobLists.get(name));
    }

    public final int getNbJobList() {
        return this.mapJobLists.size();
    }

    public final boolean addJobList(JL jl) {
        if (jl == null) {
            return false;
        }
        if (this.mapJobLists.containsKey(((JobList)jl).getName())) {
            return false;
        }
        this.mapJobLists.put(((JobList)jl).getName(), jl);
        ((JobList)jl).setUWS(this);
        return true;
    }

    public final JL removeJobList(String name) {
        JobList jl = (JobList)this.mapJobLists.get(name);
        if (jl != null && this.removeJobList(jl)) {
            return (JL)jl;
        }
        return null;
    }

    public boolean removeJobList(JL jl) {
        if (jl == null) {
            return false;
        }
        if ((jl = (JobList)this.mapJobLists.remove(((JobList)jl).getName())) != null) {
            ((JobList)jl).removeAll();
            ((JobList)jl).setUWS(null);
        }
        return jl != null;
    }

    public final boolean destroyJobList(String name) {
        return this.destroyJobList((JobList)this.mapJobLists.get(name));
    }

    public boolean destroyJobList(JL jl) {
        if (jl == null) {
            return false;
        }
        if ((jl = (JobList)this.mapJobLists.remove(((JobList)jl).getName())) != null) {
            ((JobList)jl).clear();
            ((JobList)jl).setUWS(null);
        }
        return jl != null;
    }

    public final void removeAllJobLists() {
        ArrayList<String> jlNames = new ArrayList<String>(this.mapJobLists.keySet());
        for (String jlName : jlNames) {
            this.removeJobList(jlName);
        }
    }

    public final void destroyAllJobLists() {
        ArrayList<String> jlNames = new ArrayList<String>(this.mapJobLists.keySet());
        for (String jlName : jlNames) {
            this.destroyJobList(jlName);
        }
    }

    public final boolean addUWSAction(UWSAction<JL, J> action) {
        if (!this.uwsActions.contains(action)) {
            return this.uwsActions.add(action);
        }
        return false;
    }

    public final boolean addUWSAction(int indAction, UWSAction<JL, J> action) throws ArrayIndexOutOfBoundsException {
        if (!this.uwsActions.contains(action)) {
            this.uwsActions.add(indAction, action);
            return true;
        }
        return false;
    }

    public final boolean setUWSAction(int indAction, UWSAction<JL, J> action) throws ArrayIndexOutOfBoundsException {
        if (!this.uwsActions.contains(action)) {
            this.uwsActions.set(indAction, action);
            return true;
        }
        return false;
    }

    public final UWSAction<JL, J> replaceUWSAction(UWSAction<JL, J> action) {
        if (action == null) {
            return null;
        }
        int i = 0;
        while (i < this.uwsActions.size()) {
            if (this.uwsActions.get(i).equals(action)) {
                return this.uwsActions.set(i, action);
            }
            ++i;
        }
        return null;
    }

    public final int getNbUWSActions() {
        return this.uwsActions.size();
    }

    public final UWSAction<JL, J> getUWSAction(String actionName) {
        int i = 0;
        while (i < this.uwsActions.size()) {
            if (this.uwsActions.get(i).getName().equals(actionName)) {
                return this.uwsActions.get(i);
            }
            ++i;
        }
        return null;
    }

    public final Iterator<UWSAction<JL, J>> getUWSActions() {
        return this.uwsActions.iterator();
    }

    public final UWSAction<JL, J> getExecutedAction() {
        return this.executedAction;
    }

    public final UWSAction<JL, J> removeUWSAction(int indAction) throws ArrayIndexOutOfBoundsException {
        return this.uwsActions.remove(indAction);
    }

    public final UWSAction<JL, J> removeUWSAction(String actionName) {
        int i = 0;
        while (i < this.uwsActions.size()) {
            if (this.uwsActions.get(i).getName().equals(actionName)) {
                return this.uwsActions.remove(i);
            }
            ++i;
        }
        return null;
    }

    public abstract J createJob(Map<String, String> var1) throws UWSException;

    public boolean executeRequest(HttpServletRequest request, HttpServletResponse response) throws UWSException, IOException {
        if (request == null || response == null) {
            return false;
        }
        if (this.syncStatus == null) {
            this.sync();
        }
        boolean actionApplied = false;
        UWSAction<JL, J> action = null;
        try {
            try {
                if (this.urlInterpreter == null) {
                    boolean reInitNeeded = this.reInitUrlInterpreter;
                    this.setUrlInterpreter(new UWSUrl(request));
                    this.reInitUrlInterpreter = reInitNeeded;
                }
                this.urlInterpreter.load(request);
                String userId = this.userIdentifier == null ? null : this.userIdentifier.extractUserId(this.urlInterpreter, request);
                int i = 0;
                while (action == null && i < this.uwsActions.size()) {
                    if (this.uwsActions.get(i).match(this.urlInterpreter, userId, request)) {
                        action = this.uwsActions.get(i);
                        this.choosenSerializer = null;
                        actionApplied = action.apply(this.urlInterpreter, userId, request, response);
                    }
                    ++i;
                }
                if (action == null) {
                    throw new UWSException(501, "[Execute UWS request] This UWS action is not implemented by this UWS service !");
                }
            }
            catch (UWSException ex) {
                if (ex.getHttpErrorCode() == 303) {
                    actionApplied = true;
                }
                this.sendError(ex, request, response);
                this.executedAction = action;
            }
            catch (Exception ex) {
                this.sendError(ex, request, response);
                this.executedAction = action;
            }
        }
        finally {
            this.executedAction = action;
        }
        return actionApplied;
    }

    public void redirect(String url, HttpServletRequest request, HttpServletResponse response) throws IOException, UWSException {
        response.setStatus(303);
        response.setHeader("Location", url);
    }

    public void sendError(UWSException error, HttpServletRequest request, HttpServletResponse response) throws IOException, UWSException {
        if (error.getHttpErrorCode() == 303) {
            this.redirect(error.getMessage(), request, response);
        } else {
            response.sendError(error.getHttpErrorCode(), error.getMessage());
        }
    }

    public void sendError(Exception error, HttpServletRequest request, HttpServletResponse response) throws IOException, UWSException {
        error.printStackTrace();
        response.sendError(500, error.getMessage());
    }

    @Override
    public String serialize(UWSSerializer serializer, String ownerId) throws UWSException {
        return serializer.getUWS(this, ownerId);
    }

    public void valueBound(HttpSessionBindingEvent e) {
        System.out.println("### [UWS INFO] : ADD THE UWS \"" + this.getName() + "\" IN THE SESSION N\u00b0" + e.getSession().getId() + " ! ###");
    }

    public void valueUnbound(HttpSessionBindingEvent e) {
        System.out.println("### [UWS INFO] : SESSION N\u00b0" + e.getSession().getId() + " EXPIRED => REMOVING THE UWS \"" + this.getName() + "\" => DESTROYING ALL JOBS LISTS ! ###");
        this.destroyAllJobLists();
    }
}

