/*
 * Decompiled with CFR 0.152.
 */
package uws.job.serializer;

import java.util.Iterator;
import uws.UWSException;
import uws.job.AbstractJob;
import uws.job.ErrorSummary;
import uws.job.JobList;
import uws.job.Result;
import uws.job.serializer.UWSSerializer;
import uws.service.AbstractUWS;
import uws.service.UWSUrl;

public class XMLSerializer
extends UWSSerializer {
    private static final long serialVersionUID = 1L;
    protected String tabPrefix = "";
    protected String xsltPath = null;

    public XMLSerializer() {
    }

    public XMLSerializer(String xsltPath) {
        this.xsltPath = xsltPath;
    }

    public final String getXSLTPath() {
        return this.xsltPath;
    }

    public final void setXSLTPath(String path) {
        this.xsltPath = path;
    }

    public String getHeader() {
        String xmlHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        if (this.xsltPath != null && !this.xsltPath.trim().isEmpty()) {
            xmlHeader = String.valueOf(xmlHeader) + "<?xml-stylesheet type=\"text/xsl\" href=\"" + this.xsltPath + "\"?>\n";
        }
        return xmlHeader;
    }

    public String getUWSNamespace() {
        return "xmlns:uws=\"http://www.ivoa.net/xml/UWS/v1.0\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
    }

    protected final String getUWSNamespace(boolean root) {
        if (root) {
            return " " + this.getUWSNamespace();
        }
        return "";
    }

    @Override
    public final String getMimeType() {
        return "application/xml";
    }

    @Override
    public String getUWS(AbstractUWS<? extends JobList<? extends AbstractJob>, ? extends AbstractJob> uws, String userId) {
        String name = uws.getName();
        String description = uws.getDescription();
        String xml = String.valueOf(this.getHeader()) + "<uws" + this.getUWSNamespace(true) + (name != null ? " name=\"" + name + "\"" : "") + ">\n";
        if (description != null) {
            xml = String.valueOf(xml) + "\t<description>\n" + description + "\n\t</description>\n";
        }
        xml = String.valueOf(xml) + "\t<jobLists>\n";
        for (JobList<? extends AbstractJob> jobList : uws) {
            UWSUrl jlUrl = jobList.getUrl();
            String url = jlUrl == null ? null : jlUrl.getRequestURL();
            xml = String.valueOf(xml) + "\t\t<jobListRef name=\"" + jobList.getName() + "\" href=\"" + (url == null ? "" : url) + "\" />\n";
        }
        xml = String.valueOf(xml) + "\t</jobLists>\n";
        xml = String.valueOf(xml) + "</uws>\n";
        return xml;
    }

    @Override
    public String getJobList(JobList<? extends AbstractJob> jobsList, String ownerId, boolean root) throws UWSException {
        String name = jobsList.getName();
        UWSUrl jobsListUrl = jobsList.getUrl();
        String xml = String.valueOf(this.getHeader()) + "<uws:jobList" + this.getUWSNamespace(true) + (name == null || name.isEmpty() ? "" : " name=\"" + name + "\"") + ">";
        Iterator<? extends AbstractJob> it = jobsList.getJobs(ownerId);
        while (it.hasNext()) {
            AbstractJob j = it.next();
            String url = null;
            if (jobsListUrl != null) {
                jobsListUrl.setJobId(j.getJobId());
                url = jobsListUrl.getRequestURL();
            }
            xml = String.valueOf(xml) + "\n\t<uws:jobRef id=\"" + j.getJobId() + "\" xlink:href=\"" + (url == null ? "" : url) + "\">\n\t\t" + this.getPhase(j, false) + "\n\t</uws:jobRef>";
        }
        xml = String.valueOf(xml) + "\n</uws:jobList>";
        return xml;
    }

    @Override
    public String getJob(AbstractJob job, boolean root) {
        String xml = root ? this.getHeader() : "";
        xml = String.valueOf(xml) + "<uws:job" + this.getUWSNamespace(root) + ">" + "\n\t" + this.getJobID(job, false) + "\n\t" + this.getRunID(job, false) + "\n\t" + this.getOwnerID(job, false) + "\n\t" + this.getPhase(job, false) + "\n\t" + this.getQuote(job, false) + "\n\t" + this.getStartTime(job, false) + "\n\t" + this.getEndTime(job, false) + "\n\t" + this.getExecutionDuration(job, false) + "\n\t" + this.getDestructionTime(job, false);
        this.tabPrefix = "\t";
        xml = String.valueOf(xml) + "\n" + this.getAdditionalParameters(job, false);
        xml = String.valueOf(xml) + "\n" + this.getResults(job, false);
        xml = String.valueOf(xml) + "\n" + this.getErrorSummary(job.getErrorSummary(), false);
        this.tabPrefix = "";
        return String.valueOf(xml) + "\n</uws:job>";
    }

    @Override
    public String getJobID(AbstractJob job, boolean root) {
        return String.valueOf(root ? this.getHeader() : "") + "<uws:jobId" + this.getUWSNamespace(root) + ">" + job.getJobId() + "</uws:jobId>";
    }

    @Override
    public String getRunID(AbstractJob job, boolean root) {
        String name = job.getRunId();
        if (name == null) {
            name = "";
        }
        String xml = name.isEmpty() ? "<uws:runId" + this.getUWSNamespace(root) + " xsi:nil=\"true\" />" : "<uws:runId" + this.getUWSNamespace(root) + ">" + name + "</uws:runId>";
        return String.valueOf(root ? this.getHeader() : "") + xml;
    }

    @Override
    public String getOwnerID(AbstractJob job, boolean root) {
        String owner = job.getOwner();
        if (owner == null) {
            owner = "";
        }
        String xml = owner.isEmpty() ? "<uws:ownerId" + this.getUWSNamespace(root) + " xsi:nil=\"true\" />" : "<uws:ownerId" + this.getUWSNamespace(root) + ">" + owner + "</uws:ownerId>";
        return String.valueOf(root ? this.getHeader() : "") + xml;
    }

    @Override
    public String getPhase(AbstractJob job, boolean root) {
        return String.valueOf(root ? this.getHeader() : "") + "<uws:phase" + this.getUWSNamespace(root) + ">" + (Object)((Object)job.getPhase()) + "</uws:phase>";
    }

    @Override
    public String getQuote(AbstractJob job, boolean root) {
        String quote = job.getQuote() <= 0L ? "" : String.valueOf(job.getQuote());
        String xml = quote.isEmpty() ? "<uws:quote" + this.getUWSNamespace(root) + " xsi:nil=\"true\" />" : "<uws:quote" + this.getUWSNamespace(root) + ">" + quote + "</uws:quote>";
        return String.valueOf(root ? this.getHeader() : "") + xml;
    }

    @Override
    public String getStartTime(AbstractJob job, boolean root) {
        String time = "";
        if (job.getStartTime() != null) {
            time = job.getDateFormat().format(job.getStartTime());
        }
        String xml = time.isEmpty() ? "<uws:startTime" + this.getUWSNamespace(root) + " xsi:nil=\"true\" />" : "<uws:startTime" + this.getUWSNamespace(root) + ">" + time + "</uws:startTime>";
        return String.valueOf(root ? this.getHeader() : "") + xml;
    }

    @Override
    public String getEndTime(AbstractJob job, boolean root) {
        String time = "";
        if (job.getEndTime() != null) {
            time = job.getDateFormat().format(job.getEndTime());
        }
        String xml = time.isEmpty() ? "<uws:endTime" + this.getUWSNamespace(root) + " xsi:nil=\"true\" />" : "<uws:endTime" + this.getUWSNamespace(root) + ">" + time + "</uws:endTime>";
        return String.valueOf(root ? this.getHeader() : "") + xml;
    }

    @Override
    public String getDestructionTime(AbstractJob job, boolean root) {
        String time = "";
        if (job.getDestructionTime() != null) {
            time = job.getDateFormat().format(job.getDestructionTime());
        }
        String xml = time.isEmpty() ? "<uws:destruction" + this.getUWSNamespace(root) + " xsi:nil=\"true\" />" : "<uws:destruction" + this.getUWSNamespace(root) + ">" + time + "</uws:destruction>";
        return String.valueOf(root ? this.getHeader() : "") + xml;
    }

    @Override
    public String getExecutionDuration(AbstractJob job, boolean root) {
        return String.valueOf(root ? this.getHeader() : "") + "<uws:executionDuration" + this.getUWSNamespace(root) + ">" + job.getExecutionDuration() + "</uws:executionDuration>";
    }

    @Override
    public String getErrorSummary(ErrorSummary error, boolean root) {
        if (error != null) {
            String xml = String.valueOf(root ? this.getHeader() : "") + this.tabPrefix + "<uws:errorSummary" + this.getUWSNamespace(root) + " type=\"" + (Object)((Object)error.getType()) + "\"" + " hasDetail=\"" + error.hasDetail() + "\">";
            xml = String.valueOf(xml) + "\n\t" + this.tabPrefix + "<uws:message>" + error.getMessage() + "</uws:message>";
            xml = String.valueOf(xml) + "\n" + this.tabPrefix + "</uws:errorSummary>";
            return xml;
        }
        return String.valueOf(root ? this.getHeader() : "") + this.tabPrefix + "<uws:errorSummary" + this.getUWSNamespace(root) + " xsi:nil=\"true\" />";
    }

    @Override
    public String getAdditionalParameters(AbstractJob job, boolean root) {
        String xml = String.valueOf(root ? this.getHeader() : "") + this.tabPrefix + "<uws:parameters" + this.getUWSNamespace(root) + ">";
        for (String paramName : job.getAdditionalParameters()) {
            xml = String.valueOf(xml) + "\n\t" + this.tabPrefix + this.getAdditionalParameter(paramName, job.getAdditionalParameterValue(paramName), false);
        }
        xml = String.valueOf(xml) + "\n" + this.tabPrefix + "</uws:parameters>";
        return xml;
    }

    @Override
    public String getAdditionalParameter(String paramName, String paramValue, boolean root) {
        if (paramName != null && paramValue != null) {
            if (root) {
                return paramValue;
            }
            return "<uws:parameter" + this.getUWSNamespace(root) + " id=\"" + paramName + "\"><![CDATA[" + paramValue + "]]></uws:parameter>";
        }
        return "";
    }

    @Override
    public String getResults(AbstractJob job, boolean root) {
        String xml = String.valueOf(root ? this.getHeader() : "") + this.tabPrefix + "<uws:results" + this.getUWSNamespace(root) + ">";
        Iterator<Result> it = job.getResults();
        while (it.hasNext()) {
            xml = String.valueOf(xml) + "\n\t" + this.tabPrefix + this.getResult(it.next(), false);
        }
        xml = String.valueOf(xml) + "\n" + this.tabPrefix + "</uws:results>";
        return xml;
    }

    @Override
    public String getResult(Result result, boolean root) {
        return String.valueOf(root ? this.getHeader() : "") + "<uws:result" + this.getUWSNamespace(root) + " id=\"" + result.getId() + "\"" + (result.getType() == null ? "" : " xlink:type=\"" + result.getType() + "\"") + (result.getHref() == null ? "" : " xlink:href=\"" + result.getHref() + "\"") + " />";
    }
}

