/*
 * Decompiled with CFR 0.152.
 */
package uws.job.manager;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import uws.UWSException;
import uws.job.AbstractJob;
import uws.job.ErrorType;
import uws.job.ExecutionPhase;
import uws.job.manager.ExecutionManager;

public class QueuedExecutionManager
implements ExecutionManager {
    private static final long serialVersionUID = 1L;
    protected transient Map<String, AbstractJob> runningJobs;
    protected transient Vector<AbstractJob> queuedJobs;
    protected int nbMaxRunningJobs = 0;
    public static final int NO_QUEUE = 0;

    public QueuedExecutionManager() {
        this.sync();
    }

    public QueuedExecutionManager(int maxRunningJobs) {
        this.nbMaxRunningJobs = maxRunningJobs <= 0 ? 0 : maxRunningJobs;
        this.sync();
    }

    @Override
    public final synchronized void sync() {
        if (this.runningJobs == null) {
            this.runningJobs = new LinkedHashMap<String, AbstractJob>();
        }
        if (this.queuedJobs == null) {
            this.queuedJobs = new Vector(0, 10);
        }
    }

    @Override
    public final synchronized Iterator<AbstractJob> getRunningJobs() {
        if (this.runningJobs == null) {
            this.sync();
        }
        return this.runningJobs.values().iterator();
    }

    @Override
    public final synchronized int getNbRunningJobs() {
        if (this.runningJobs == null) {
            this.sync();
        }
        return this.runningJobs.size();
    }

    @Override
    public final synchronized Iterator<AbstractJob> getQueuedJobs() {
        if (this.runningJobs == null) {
            this.sync();
        }
        return this.queuedJobs.iterator();
    }

    @Override
    public final synchronized int getNbQueuedJobs() {
        if (this.runningJobs == null) {
            this.sync();
        }
        return this.queuedJobs.size();
    }

    @Override
    public void setNoQueue() {
        this.nbMaxRunningJobs = 0;
        try {
            this.refresh();
        }
        catch (UWSException ue) {
            ue.printStackTrace();
        }
    }

    @Override
    public boolean hasQueue() {
        return this.nbMaxRunningJobs > 0;
    }

    public final int getMaxRunningJobs() {
        return this.nbMaxRunningJobs;
    }

    public void setMaxRunningJobs(int maxRunningJobs) throws UWSException {
        this.nbMaxRunningJobs = maxRunningJobs <= 0 ? 0 : maxRunningJobs;
        this.refresh();
    }

    @Override
    public final synchronized void refresh() throws UWSException {
        if (this.runningJobs == null) {
            this.sync();
        }
        if (!this.hasQueue()) {
            return;
        }
        String allMsg = null;
        while (!this.queuedJobs.isEmpty() && this.isReadyForExecution(this.queuedJobs.firstElement())) {
            AbstractJob job = this.queuedJobs.remove(0);
            try {
                if (job == null) continue;
                job.start(false);
                this.runningJobs.put(job.getJobId(), job);
            }
            catch (UWSException ue) {
                allMsg = String.valueOf(allMsg == null ? "ERRORS THAT OCCURED WHILE REFRESHING THE EXECUTION MANAGER:" : allMsg) + "\n\t- " + ue.getMessage();
            }
        }
        if (allMsg != null) {
            throw new UWSException(500, allMsg, ErrorType.TRANSIENT);
        }
    }

    @Override
    public final synchronized ExecutionPhase execute(AbstractJob jobToExecute) throws UWSException {
        if (jobToExecute == null) {
            return null;
        }
        try {
            this.refresh();
        }
        catch (UWSException ue) {
            ue.printStackTrace();
        }
        if (jobToExecute.isRunning()) {
            this.runningJobs.put(jobToExecute.getJobId(), jobToExecute);
        } else if (jobToExecute.isFinished()) {
            this.runningJobs.remove(jobToExecute);
            this.queuedJobs.remove(jobToExecute);
        } else if (this.hasQueue() && jobToExecute.getPhase() == ExecutionPhase.QUEUED) {
            if (!this.queuedJobs.contains(jobToExecute)) {
                this.queuedJobs.add(jobToExecute);
                this.refresh();
            }
        } else if (!this.hasQueue() || this.isReadyForExecution(jobToExecute)) {
            jobToExecute.start(false);
            this.runningJobs.put(jobToExecute.getJobId(), jobToExecute);
            this.queuedJobs.remove(jobToExecute);
        } else {
            jobToExecute.setPhase(ExecutionPhase.QUEUED);
            if (!this.queuedJobs.contains(jobToExecute)) {
                this.queuedJobs.add(jobToExecute);
            }
        }
        return jobToExecute.getPhase();
    }

    @Override
    public final boolean isReadyForExecution(AbstractJob jobToExecute) {
        if (this.runningJobs == null) {
            this.sync();
        }
        if (jobToExecute == null || jobToExecute.isFinished()) {
            return false;
        }
        if (!this.hasQueue()) {
            return true;
        }
        return this.runningJobs.size() < this.nbMaxRunningJobs;
    }

    @Override
    public final synchronized void update(AbstractJob job) throws UWSException {
        if (this.runningJobs == null) {
            this.sync();
        }
        if (job == null || job.isFinished()) {
            return;
        }
        if (job.isRunning()) {
            this.runningJobs.put(job.getJobId(), job);
        } else if (this.hasQueue() && job.getPhase() == ExecutionPhase.QUEUED && !this.queuedJobs.contains(job)) {
            this.queuedJobs.add(job);
        }
        this.refresh();
    }

    @Override
    public final synchronized void remove(AbstractJob jobToRemove) throws UWSException {
        if (this.runningJobs == null) {
            this.sync();
        }
        if (jobToRemove == null) {
            return;
        }
        this.runningJobs.remove(jobToRemove.getJobId());
        this.queuedJobs.remove(jobToRemove);
        this.refresh();
    }
}

