/*
 * Decompiled with CFR 0.152.
 */
package uws.job;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import uws.UWSException;
import uws.job.serializer.UWSSerializer;

public abstract class SerializableUWSObject
implements Serializable {
    private static final long serialVersionUID = 1L;

    public String serialize(UWSSerializer serializer) throws UWSException {
        return this.serialize(serializer, null);
    }

    public abstract String serialize(UWSSerializer var1, String var2) throws UWSException;

    public void serialize(OutputStream output, UWSSerializer serializer) throws UWSException {
        this.serialize(output, serializer, null);
    }

    public void serialize(OutputStream output, UWSSerializer serializer, String ownerId) throws UWSException {
        if (output == null) {
            throw new UWSException(500, "[Serialize] Impossible to serialize {" + this.toString() + "} because the given stream is null !");
        }
        try {
            String serialization = this.serialize(serializer, ownerId);
            if (serialization == null) {
                throw new UWSException(500, "[Serialize] Impossible to write the serialization of {" + this.toString() + "} because it is NULL !");
            }
            output.write(serialization.getBytes());
        }
        catch (IOException ex) {
            throw new UWSException(500, (Throwable)ex, "[Serialize] Impossible to serialize {" + this.toString() + "} !");
        }
    }
}

