/*
 * Decompiled with CFR 0.152.
 */
package uws.job;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import uws.UWSException;
import uws.job.AbstractJob;
import uws.job.SerializableUWSObject;
import uws.job.manager.DefaultDestructionManager;
import uws.job.manager.DestructionManager;
import uws.job.serializer.UWSSerializer;
import uws.service.AbstractUWS;
import uws.service.UWSUrl;

public class JobList<J extends AbstractJob>
extends SerializableUWSObject
implements Iterable<J> {
    private static final long serialVersionUID = 1L;
    private final String name;
    protected final Map<String, J> jobsList;
    protected final Map<String, Map<String, J>> ownerJobs;
    private DestructionManager destructionManager;
    private AbstractUWS uws = null;

    public JobList(String jobListName) throws UWSException {
        if (jobListName == null) {
            throw new UWSException(500, "[Create a jobs list] The given jobs list name is NULL !");
        }
        if ((jobListName = jobListName.trim()).length() == 0) {
            throw new UWSException(500, "[Create a jobs list] The given jobs list name is empty !");
        }
        this.name = jobListName;
        this.jobsList = new LinkedHashMap<String, J>();
        this.ownerJobs = new LinkedHashMap<String, Map<String, J>>();
        this.destructionManager = new DefaultDestructionManager();
    }

    public final synchronized void sync() {
        LinkedList<String> jobToDestroy = new LinkedList<String>();
        if (this.destructionManager != null) {
            this.destructionManager.refresh();
        }
        for (AbstractJob job : this) {
            if (job.sync()) continue;
            jobToDestroy.add(job.getJobId());
        }
        for (String jobId : jobToDestroy) {
            this.destroyJob(jobId);
        }
    }

    public final AbstractUWS getUWS() {
        return this.uws;
    }

    public final void setUWS(AbstractUWS newUws) {
        this.uws = newUws;
        this.setDestructionManager(this.uws == null ? null : this.uws.getDestructionManager());
    }

    public final DestructionManager getDestructionManager() {
        return this.destructionManager;
    }

    public final void setDestructionManager(DestructionManager newManager) {
        DestructionManager oldManager = this.destructionManager;
        this.destructionManager = newManager;
        if (oldManager != null || this.destructionManager != null) {
            for (AbstractJob job : this) {
                if (oldManager != null) {
                    oldManager.remove(job);
                }
                if (this.destructionManager == null) continue;
                this.destructionManager.update(job);
            }
        }
    }

    public UWSUrl getUrl() {
        if (this.uws == null || this.uws.getUrlInterpreter() == null) {
            return null;
        }
        return this.uws.getUrlInterpreter().listJobs(this.getName());
    }

    public final String getName() {
        return this.name;
    }

    public final J getJob(String jobID) {
        return (J)((AbstractJob)this.jobsList.get(jobID));
    }

    public final Iterator<J> getJobs() {
        return this.iterator();
    }

    public final Iterator<J> getJobs(String ownerId) {
        if (ownerId == null) {
            return this.iterator();
        }
        if (this.ownerJobs.containsKey(ownerId)) {
            return this.ownerJobs.get(ownerId).values().iterator();
        }
        return new Iterator<J>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public J next() {
                return null;
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public final Iterator<J> iterator() {
        return this.jobsList.values().iterator();
    }

    public final int getNbJobs() {
        return this.jobsList.size();
    }

    public final int getNbJobs(String ownerId) {
        if (ownerId == null) {
            return this.getNbJobs();
        }
        if (this.ownerJobs.containsKey(ownerId)) {
            return this.ownerJobs.get(ownerId).size();
        }
        return 0;
    }

    public final Iterator<String> getUsers() {
        return this.ownerJobs.keySet().iterator();
    }

    public final int getNbUsers() {
        return this.ownerJobs.size();
    }

    public final ArrayList<J> searchJobs(String runID) {
        ArrayList<AbstractJob> foundJobs = new ArrayList<AbstractJob>();
        String string = runID = runID != null ? runID.trim() : runID;
        if (runID != null && !runID.isEmpty()) {
            for (AbstractJob job : this) {
                if (!job.getRunId().equalsIgnoreCase(runID)) continue;
                foundJobs.add(job);
            }
        }
        return foundJobs;
    }

    public String addNewJob(J j) throws UWSException {
        if (j == null || this.jobsList.containsKey(((AbstractJob)j).getJobId())) {
            return null;
        }
        ((AbstractJob)j).loadAdditionalParams();
        this.jobsList.put(((AbstractJob)j).getJobId(), j);
        if (((AbstractJob)j).getOwner() != null) {
            if (!this.ownerJobs.containsKey(((AbstractJob)j).getOwner())) {
                this.ownerJobs.put(((AbstractJob)j).getOwner(), new LinkedHashMap());
            }
            this.ownerJobs.get(((AbstractJob)j).getOwner()).put(((AbstractJob)j).getJobId(), j);
        }
        ((AbstractJob)j).setJobList(this);
        this.destructionManager.update((AbstractJob)j);
        ((AbstractJob)j).applyPhaseParam();
        return ((AbstractJob)j).getJobId();
    }

    public final void updateDestruction(J job) {
        if (this.destructionManager != null && job != null && ((AbstractJob)job).getJobList() != null && ((AbstractJob)job).getJobList().equals(this)) {
            this.destructionManager.update((AbstractJob)job);
        }
    }

    public J removeJob(String jobId) {
        AbstractJob removedJob;
        AbstractJob abstractJob = removedJob = jobId == null ? null : (AbstractJob)this.jobsList.remove(jobId);
        if (removedJob != null) {
            try {
                removedJob.setJobList(null);
            }
            catch (UWSException uWSException) {
                // empty catch block
            }
            if (this.ownerJobs.containsKey(removedJob.getOwner())) {
                this.ownerJobs.get(removedJob.getOwner()).remove(jobId);
                if (this.ownerJobs.get(removedJob.getOwner()).isEmpty()) {
                    this.ownerJobs.remove(removedJob.getOwner());
                }
            }
            if (this.destructionManager != null) {
                this.destructionManager.remove(removedJob);
            }
            return (J)removedJob;
        }
        return null;
    }

    public boolean destroyJob(String jobId) {
        J destroyedJob = this.removeJob(jobId);
        if (destroyedJob != null) {
            ((AbstractJob)destroyedJob).clearResources();
            return true;
        }
        return false;
    }

    public void removeAll() {
        ArrayList<String> jobIDs = new ArrayList<String>(this.jobsList.keySet());
        for (String id : jobIDs) {
            this.removeJob(id);
        }
    }

    public void clear() {
        ArrayList<String> jobIDs = new ArrayList<String>(this.jobsList.keySet());
        for (String id : jobIDs) {
            this.destroyJob(id);
        }
    }

    public void clear(String ownerId) {
        if (ownerId == null) {
            this.clear();
        } else if (this.ownerJobs.containsKey(ownerId)) {
            ArrayList<String> jobIDs = new ArrayList<String>(this.ownerJobs.get(ownerId).keySet());
            for (String id : jobIDs) {
                this.destroyJob(id);
            }
            this.ownerJobs.remove(ownerId);
        }
    }

    @Override
    public String serialize(UWSSerializer serializer, String ownerId) throws UWSException {
        return serializer.getJobList(this, ownerId, true);
    }

    public String toString() {
        return "JOB_LIST {name: \"" + this.getName() + "\"; nbJobs: " + this.jobsList.size() + "}";
    }
}

