/*
 * Decompiled with CFR 0.152.
 */
package uws;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import uws.UWSException;
import uws.job.AbstractJob;
import uws.job.ErrorSummary;
import uws.job.ErrorType;
import uws.job.serializer.XMLSerializer;
import uws.service.AbstractUWS;
import uws.service.UWSUrl;

public class UWSToolBox {
    private UWSToolBox() {
    }

    public static final URL getServerResource(String serverPath, HttpServletRequest req) {
        if (serverPath == null || req == null) {
            return null;
        }
        try {
            if (!serverPath.startsWith("/")) {
                serverPath = "/" + serverPath;
            }
            return new URL(String.valueOf(req.getRequestURL().substring(0, req.getRequestURL().lastIndexOf(req.getContextPath()) + req.getContextPath().length())) + serverPath);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static final Map<String, String> getParamsMap(HttpServletRequest req) {
        HashMap<String, String> params = new HashMap<String, String>(req.getParameterMap().size());
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            params.put(obj.toString().toLowerCase(), req.getParameter(obj.toString()));
        }
        return params;
    }

    public static final Map<String, String> getParamsMap(HttpServletRequest req, String userId) {
        HashMap params = (HashMap)UWSToolBox.getParamsMap(req);
        if (!params.containsKey("owner")) {
            params.put("owner", userId);
        }
        return params;
    }

    public static final String getQueryPart(Map<String, String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return "";
        }
        StringBuffer queryPart = new StringBuffer();
        for (Map.Entry<String, String> e : parameters.entrySet()) {
            String key = e.getKey();
            String val = e.getValue();
            if (key != null) {
                key = key.trim().toUpperCase();
            }
            if (val != null) {
                val = val.trim();
            }
            if (key == null || key.isEmpty() || val == null || val.isEmpty()) continue;
            queryPart.append(String.valueOf(e.getKey()) + "=" + val);
            queryPart.append("&");
        }
        return queryPart.substring(0, queryPart.length() - 1);
    }

    public static final Map<String, String> getParameters(String queryPart) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (queryPart != null && !(queryPart = queryPart.substring(queryPart.indexOf("?") + 1).trim()).isEmpty()) {
            String[] keyValues;
            String[] stringArray = keyValues = queryPart.split("&");
            int n = keyValues.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                String[] keyValue = item.split("=");
                if (keyValue.length == 2) {
                    keyValue[0] = keyValue[0].trim().toLowerCase();
                    keyValue[1] = keyValue[1].trim();
                    if (!keyValue[0].isEmpty() && !keyValue[1].isEmpty()) {
                        parameters.put(keyValue[0].trim(), keyValue[1].trim());
                    }
                }
                ++n2;
            }
        }
        return parameters;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean saveUWS(AbstractUWS uws, File restoreFile, boolean debug) {
        if (uws == null) {
            return false;
        }
        if (debug) {
            System.out.print("### [UWS INFO] : DESTRUCTION => WRITING RESTORATION FILE FOR " + uws.getName() + "....");
        }
        if (restoreFile != null) {
            ObjectOutputStream out = null;
            try {
                out = new ObjectOutputStream(new FileOutputStream(restoreFile));
                out.writeObject(uws);
                out.close();
                if (!debug) return true;
                System.out.println("OK ! ###");
                return true;
            }
            catch (IOException ex) {
                if (!debug) return false;
                System.out.println("ERROR (" + ex.getMessage() + ") ! ###");
                ex.printStackTrace();
                return false;
            }
        } else {
            if (!debug) return false;
            System.out.println("ERROR (no restoration file) ! ###");
        }
        return false;
    }

    public static final AbstractUWS restoreUWS(File restoreFile, boolean debug) throws ServletException {
        AbstractUWS uws = null;
        if (debug) {
            System.out.print("### [UWS INFO] : INIT => RESTORATION...");
        }
        try {
            ObjectInputStream input = new ObjectInputStream(new FileInputStream(restoreFile));
            uws = (AbstractUWS)input.readObject();
            input.close();
            if (debug) {
                System.out.println("OK [" + uws.getName() + " ; " + restoreFile.getAbsolutePath() + "] ! ###");
            }
        }
        catch (FileNotFoundException ex) {
            if (debug) {
                System.out.println("Nothing to restore (no restoration file found) ! ###");
            }
        }
        catch (ClassNotFoundException e) {
            throw new ServletException("Impossible to restore the UWS from \"" + restoreFile.getAbsolutePath() + "\" because no instance of AbstractUWS has been found !", (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new ServletException("Impossible to restore the UWS from \"" + restoreFile.getAbsolutePath() + "\" because the read object can not be cast into AbstractUWS !", (Throwable)e);
        }
        catch (IOException ex) {
            throw new ServletException("Impossible to restore the UWS from \"" + restoreFile.getAbsolutePath() + "\" !", (Throwable)ex);
        }
        return uws;
    }

    public static final void clearDirectory(String directoryPath) {
        UWSToolBox.clearDirectory(new File(directoryPath));
    }

    public static final void clearDirectory(File directory) {
        if (directory != null && directory.exists() && directory.isDirectory() && directory.canWrite()) {
            File[] files = directory.listFiles();
            int i = 0;
            while (i < files.length) {
                files[i].delete();
                ++i;
            }
        }
    }

    public static final boolean publishErrorSummary(AbstractJob j, String msg, ErrorType type) throws UWSException {
        if (j == null) {
            return false;
        }
        j.error(new ErrorSummary(msg, type));
        return true;
    }

    public static final boolean publishErrorSummary(AbstractJob j, Exception ex, ErrorType type, String errorFileUri, String errorsDirectory, String errorFileName) throws IOException, UWSException {
        if (j == null || ex == null) {
            return false;
        }
        boolean written = UWSToolBox.writeErrorFile(ex, errorsDirectory, errorFileName);
        try {
            j.error(new ErrorSummary(ex, type, written ? errorFileUri : null));
            return true;
        }
        catch (UWSException ue) {
            File f = new File(errorFileName);
            if (f.exists()) {
                f.delete();
            }
            throw ue;
        }
    }

    public static final boolean writeErrorFile(Exception ex, String errorsDirectory, String errorFileName) throws IOException {
        return UWSToolBox.writeErrorFile(ex, errorsDirectory, errorFileName, false);
    }

    public static final boolean writeErrorFile(Exception ex, String errorsDirectory, String errorFileName, boolean overwrite) throws IOException {
        File errorFile;
        if (ex == null) {
            return false;
        }
        File dir = new File(errorsDirectory);
        if (dir.exists() && dir.isDirectory() && (!(errorFile = new File(errorsDirectory, errorFileName)).exists() || errorFile.exists() && errorFile.isFile() && overwrite)) {
            PrintWriter pw = new PrintWriter(errorFile);
            ex.printStackTrace(pw);
            pw.close();
            return true;
        }
        return false;
    }

    public static final void printURL(UWSUrl url) {
        try {
            UWSToolBox.printURL(url, System.out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final void printURL(UWSUrl url, OutputStream output) throws IOException {
        String toPrint = "***** UWS_URL (" + url.getBaseURI() + ") *****\nRequest URL: " + url.getRequestURL() + "\nRequest URI: " + url.getRequestURI() + "\nUWS URI: " + url.getUwsURI() + "\nJob List: " + url.getJobListName() + "\nJob ID: " + url.getJobId() + "\nAttributes (" + url.getAttributes().length + "):";
        String[] stringArray = url.getAttributes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String att = stringArray[n2];
            toPrint = String.valueOf(toPrint) + " " + att;
            ++n2;
        }
        toPrint = String.valueOf(toPrint) + "\n";
        output.write(toPrint.getBytes());
    }

    @Deprecated
    public static final String getUWSNamespace() {
        return new XMLSerializer().getUWSNamespace();
    }

    @Deprecated
    public static final boolean publishErrorSummary(AbstractJob j, Exception ex, ErrorType type, URL errorFileUrl, String errorsDirectory, String errorFileName) throws IOException, UWSException {
        return UWSToolBox.publishErrorSummary(j, ex, type, errorFileUrl.toString(), errorsDirectory, errorFileName);
    }
}

