/*
 * Decompiled with CFR 0.152.
 */
package uws;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AcceptHeader {
    private Map<String, Float> mMimeTypes = new HashMap<String, Float>();
    private Map<Float, List<String>> mSortedMimeTypes;

    public AcceptHeader(String acceptS) {
        String[] mimeTypes = acceptS.split(",");
        for (String mimeType : Arrays.asList(mimeTypes)) {
            Float quality = new Float(1.0f);
            String[] split = mimeType.split(";");
            if (split.length > 1) {
                String[] qualitySplit = split[1].split("=");
                quality = Float.valueOf(Float.parseFloat(qualitySplit[1]));
            }
            this.mMimeTypes.put(split[0], quality);
        }
        this.mSortedMimeTypes = new HashMap<Float, List<String>>();
        Set<Map.Entry<String, Float>> mimeTypesES = this.mMimeTypes.entrySet();
        for (Map.Entry<String, Float> mimeType : mimeTypesES) {
            if (!this.mSortedMimeTypes.containsKey(mimeType.getValue())) {
                ArrayList<String> mimeTypesL = new ArrayList<String>();
                mimeTypesL.add(mimeType.getKey());
                this.mSortedMimeTypes.put(mimeType.getValue(), mimeTypesL);
                continue;
            }
            this.mSortedMimeTypes.get(mimeType.getValue()).add(mimeType.getKey());
        }
    }

    public final Map<String, Float> getMimeTypes() {
        return this.mMimeTypes;
    }

    public final void setMimeTypes(Map<String, Float> mimeTypes) {
        this.mMimeTypes = mimeTypes;
    }

    public String getPreferredMimeType() {
        if (this.mSortedMimeTypes.size() == 0) {
            return "*/*";
        }
        Float[] qualities = this.mSortedMimeTypes.keySet().toArray(new Float[0]);
        Arrays.sort(qualities, Collections.reverseOrder());
        String choosenMimeType = null;
        for (Float key : Arrays.asList(qualities)) {
            List<String> mimeTypes = this.mSortedMimeTypes.get(key);
            String htmlMimeType = null;
            for (String mimeType : mimeTypes) {
                if (mimeType.equals("application/xhtml+xml") || mimeType.equals("text/html")) {
                    htmlMimeType = mimeType;
                    break;
                }
                if (!mimeType.equals("text/xml") && !mimeType.equals("application/json")) continue;
                choosenMimeType = mimeType;
            }
            if (htmlMimeType != null) {
                return htmlMimeType;
            }
            if (choosenMimeType == null) continue;
            return choosenMimeType;
        }
        return choosenMimeType;
    }

    public ArrayList<String> getOrderedMimeTypes() {
        Float[] qualities = this.mSortedMimeTypes.keySet().toArray(new Float[0]);
        Arrays.sort(qualities, Collections.reverseOrder());
        ArrayList<String> orderedMimeTypes = new ArrayList<String>();
        int i = 0;
        while (i < qualities.length) {
            List<String> mimeTypes = this.mSortedMimeTypes.get(qualities[i]);
            if (mimeTypes != null) {
                orderedMimeTypes.addAll(mimeTypes);
            }
            ++i;
        }
        return orderedMimeTypes;
    }
}

